function Mpi = get_Mpi(i,pi_vec)

% Computes M_pi for a given (i,pi_vec). The representation of belief sets
% is as usual.

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

%-------------
% computation
%-------------

% set pi_i (pi_i(wi,wni), for each (wi,wni))

switch i
    
 case(1)
  
  pi_i = zeros(NW(1),NW(2));
        
  for w=1:NW(1)*NW(2)
    
    pi_i(jstate(w,:)) = pi_vec(w);
       
  end

 case(2)
  
  pi_i = zeros(NW(2),NW(1));
        
  for w=1:NW(1)*NW(2)
    
    pi_i(fliplr(jstate(w,:))) = pi_vec(w);
       
  end
  
end

% compute Mpi

Mpi(NW(i)) = struct;

for wi=1:NW(i)
    
    pi_i_marg = sum(pi_i(wi,:)); % marg prob of wi under pi
    
    if (pi_i_marg==0.0) % marg prob is zero, so Mpi(wi) is empty
      
      Mpi(wi).emp = 1;
      Mpi(wi).ext = NaN;
  
    else % marg prob is positive, so Mpi(wi) is singleton 
      
      Mpi(wi).emp = 0;
      Mpi(wi).ext = pi_i(wi,:)/pi_i_marg;
  
    end 
    
end